#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
from __future__ import print_function

import logging
import sys
from multiprocessing.pool import ThreadPool

import requests

logging.basicConfig(filename='stids_with_sizes.tsv', level=logging.WARN, format='%(message)s')

STORAGE_URL = 'http://storage.mail.yandex.net:10010/gate/get/%s'
STORAGE_PARAMS = {'ns': 'disk', 'service': 'disk'}


def handle_stid(record):
    stid = record.lstrip('stid=').rstrip()
    for i in range(3):
        try:
            r = requests.head(STORAGE_URL % stid, params=STORAGE_PARAMS)
            if r.status_code != 200:
                if r.status_code == 404:
                    logging.warn('%s\t0' % stid)
                    return 1
                r.raise_for_status()
            size = r.headers.get('X-Data-Size')
        except Exception as e:
            print('%s -> %s' % (stid, e), file=sys.stderr)
        else:
            logging.warn('%s\t%s' % (stid, size))
            return 1
    return 0


pool = ThreadPool(50)

for is_handled in pool.imap_unordered(handle_stid, sys.stdin):
    pass
