#!/usr/bin/env bash
set -e

OWNER="DISK-ADMIN"


while getopts c:e:d:m:rav option
do
  case "$option" in
    c)
       CLUSTER=$OPTARG
       ;;
    e)
       ENVIRONMENT=$OPTARG
       ;;
    d)
       DIRECTORY=$OPTARG
       ;;
    r)
       RELEASE=1
       ;;
    m)
       RELEASE_MESSAGE=${OPTARG}
       ;;
    a)
       USE_ARC=1
      ;;
    v)
       VERBOSE=1
      ;;
   esac
done


if [ "$VERBOSE" = 1 ]; then
  set -x
fi

if ! [[ "$ENVIRONMENT" =~ ^(stable|prestable|testing|stable-hdd|stable-yt|stable-02|stable-03|stable-04)$ ]]; then
  echo "Environment shoud be one of: stable prestable testing"
  exit 1
fi

if [ -z "$DIRECTORY" ]; then
   DIRECTORY=$ENVIRONMENT
fi

CLUSTER=${CLUSTER:=$(basename "$PWD")}

if [ "$USE_ARC" = 1 ]; then
    arc checkout trunk
    arc pull
else
    "$ARCADIA_PATH"/ya svn up
fi

if [ "$RELEASE" = 1 ]; then
  RELEASE_OPTS=(--prepare-yd-release --release ${ENVIRONMENT} --release-subject "${RELEASE_MESSAGE:=autorelease for configs}")
fi

DESCRIPTION="$CLUSTER overrides for $DIRECTORY"


"$ARCADIA_PATH"/ya upload \
  --tar \
  --attr="cluster=$CLUSTER" \
  --attr="environment=$DIRECTORY" \
  --description="$DESCRIPTION" \
  --owner="$OWNER" \
  --root="$DIRECTORY" \
  --ttl=inf \
  --type="DISK_COMPRESSED_RESOURCE_$(echo "$ENVIRONMENT" | tr a-z A-Z| cut -f 1 -d '-')" \
  "${RELEASE_OPTS[@]}" \
  "$DIRECTORY"
