#!/bin/bash

usage="Usage:	yasm_curl.sh  panels|alerts <name>  render|update|apply|text|create  <template_file | [dev|adm|dev+adm]>

	panels/alerts - template type

	<name> - yasm template name

	render - outputs rendered jinja
	text   - outputs final json
	update - upload template file to yasm
	apply  - apply changes with uploaded template (required for alerts)
	create - create template page with admin/dev responsible

	<template_file> - path to jinja2 template file
	<dev|adm|dev+adm> - string with responsible template (if action = create)

"
http="https://yasm.yandex-team.ru/srvambry/tmpl"

die (){
	printf "$usage"
	exit
}

if (( $# < 3 || $# > 4 )); then
	die
fi

args=($@)
case ${args[0]} in
	p*)
		ctype=panels;;
	a*)
		ctype=alerts;;
	*)
		die;;
esac
name=${args[1]}
case ${args[2]} in
	r*)
		action=render;;
	t*)
		action=text;;
	u*)
		action=update;;
	a*)
		action=apply;;
	c*)
		action=create;;
	*)
		die;;
esac
if [[ $action != a* ]]; then
	if (( $# != 4 )); then
		die
	fi
	jinja=${args[3]}
fi

if [[ $action == render ]]; then
	url="$http/$ctype/render_json/$name"
	curl -s --data-binary @$jinja $url

elif [[ $action == text ]]; then
	url="$http/$ctype/render_text/$name"
	curl -s --data-binary @$jinja $url

elif [[ $action == update ]]; then
	url="$http/$ctype/update/content?key=$name"
	curl -s -XPOST --data-binary @$jinja $url

elif [[ $action == apply ]]; then
	url="$http/$ctype/apply/$name"
	curl -s -XPOST $url
elif [[ $action == create ]]; then
	url="$http/$ctype/create"
	owners=${args[3]}

	ADMINS=("ignition" "ivanov-d-s" "kolyann" "vadzay" "bp2work")
	DEV=("akinfold" "kis8ya" "shirankov" "friendlyevil" "sanya2013" "yak-dmitriy" "c4et4uk" "derovi")

	RESPONSIBLE=()
	if [[ $owners = *adm* ]]; then
		RESPONSIBLE+=(${ADMINS[@]})
	fi
	if [[ $owners = *dev* ]]; then
		RESPONSIBLE+=(${DEV[@]})
	fi
	if [ -z "$RESPONSIBLE" ]; then
		RESPONSIBLE=( $USER )
	fi
	resp_str=`echo ${RESPONSIBLE[@]} | perl -pe 's/([^ \0\n\t]+)/"\1"/g' | perl -pe 's/ /, /g; s/^/[/; s/$/]/'`
	data='{"key": "'$name'", "abc": "chemodan", "owners": '$resp_str'}'
	curl -d "$data" $url

fi
echo

