package ru.yandex.chemodan.app.persapi;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.persapi.api.TvmClientIdBinder;
import ru.yandex.chemodan.app.persapi.util.AxisBenderUtils;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author tolmalev
 */
@Configuration
public class FactApiA3ContextConfiguration {
    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo, Tvm2 tvm2) {
        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        BenderMapper generalBenderMapper = AxisBenderUtils.getA3BenderMapper();

        configurator
                .addJsonBending(generalBenderMapper).getBuilder()

                .addParameterBinders(Cf.list(
                        new TvmClientIdBinder(tvm2)))

                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo),
                        new ThreadLocalCacheInterceptor()))

                .withPerCallAttribute(ErrorResult.SUPPRESS_STACK_TRACE_ATTR, true);

        return configurator.configure();
    }
}
