package ru.yandex.chemodan.app.persapi;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.persapi.api.FactApiActionsContextConfiguration;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.script.cosher.nashorn.NashornInterpreterFactory;
import ru.yandex.commune.script.cosher.server.ScriptTelnetServer;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.version.AppName;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        FactApiCoreConfiguration.class,
        FactApiA3ContextConfiguration.class,
        FactApiActionsContextConfiguration.class,
        A3JettyContextConfiguration.class,
        Tvm2BaseContextConfiguration.class
})
public class FactApiContextConfiguration {

    @Bean
    public DiskAppVersion version() {
        return DiskAppVersion.VERSION;
    }

    @Bean
    public ApplicationInfo applicationInfo(AppName appName, DiskAppVersion appVersion) {
        return new ApplicationInfo(appName.appName(), appVersion.getProjectVersion());
    }

    @Bean
    public ScriptTelnetServer scriptTelnetServer() {
        return new ScriptTelnetServer(new NashornInterpreterFactory(), 8080, true);
    }

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/v1/facts/*", ru.yandex.chemodan.util.web.NS.API,
                "/v1/api/*", ru.yandex.chemodan.util.web.NS.API,
                "/facts/*", ru.yandex.chemodan.util.web.NS.API,
                "/api/*", ru.yandex.chemodan.util.web.NS.API,
                "/internal/*", "internal"
        ));
    }
}
