package ru.yandex.chemodan.app.persapi;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.persapi.acl.FactAclContextConfiguration;
import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.chemodan.app.persapi.schema.FactSchemaManager;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.ping.PingerChecker;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.inside.bunker.BunkerClient;
import ru.yandex.inside.logbroker.push.PushClient;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        FactAclContextConfiguration.class
})
public class FactApiCoreConfiguration {

    @Bean
    public BunkerClient bunkerClient(
            @Value("${bunker.project}")
            String bunkerProject,
            @Value("${bunker.host}")
            String bunkerHost)
    {
        return new BunkerClient(bunkerProject, bunkerHost, ApacheHttpClient4.wrap(bunkerHttpClientConfigurator().configure()));
    }

    @Bean
    @OverridableValuePrefix("bunker")
    public HttpClientConfigurator bunkerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public FactManager factManager(
            FactAclManager factAclManager,
            FactSchemaManager schemaManager,
            PushClient pushClient,
            @Value("${factmanager.push.timeout}") Duration pushTimeout)
    {
        return new FactManager(factAclManager, schemaManager, pushClient, pushTimeout);
    }

    @Bean
    public FactSchemaManager factSchemaManager(
            BunkerClient bunkerClient,
            @Value("${bunker.config.update.period}")
            Duration updatePeriod)
    {
        return new FactSchemaManager(bunkerClient, updatePeriod);
    }

    @Bean
    public PushClient allFactsPushClient(
            @Value("${logbroker.host}")
            String server,
            @Value("${logbroker.port}")
            int port,
            @Value("${logbroker.ident}")
            String ident,
            @Value("${service_axis_all.all-facts.log-type}")
            String logType,
            @Value("${logbroker.push.sessions}")
            int sessionsCount,
            @Value("${logbroker.push.threads}")
            int threadsCount,
            @Value("${logbroker.push.timeout.socket}")
            Duration soTimeout,
            @Value("${logbroker.push.timeout.connection}")
            Duration connTimeout)
    {
        PushClient pushClient = new PushClient(server, port, ident, logType, sessionsCount, threadsCount,
                new Timeout(soTimeout.getMillis(), connTimeout.getMillis()));

        pushClient.setDefaultReschedulePolicy(new RescheduleConstant(Duration.millis(50), 10));

        return pushClient;
    }

    @Bean
    public PingerChecker pushClientPingerChecker(PushClient pushClient) {
        return pushClient::isAlive;
    }
}
