package ru.yandex.chemodan.app.persapi.acl;

import ru.yandex.chemodan.util.exception.A3ExceptionWithNoStackTrace;
import ru.yandex.commune.a3.action.http.HttpStatus;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
public class AccessDeniedException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSource {

    public AccessDeniedException(String clientId, String source, String factType, AccessType accessType) {
        super("forbidden", StringUtils.format("Access denied for client={}, source={}, fact-type={}, access-type={}",
                clientId, source, factType, accessType)
        );
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.FORBIDDEN.getStatusCode();
    }
}
