package ru.yandex.chemodan.app.persapi.acl;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;

/**
 * @author tolmalev
 */
public enum AccessLevel {
    DENY_ALL(Cf.set()),
    READ_ONLY(Cf.set(AccessType.READ)),
    WRITE_ONLY(Cf.set(AccessType.WRITE)),
    READ_WRITE(Cf.set(AccessType.READ, AccessType.WRITE))
    ;


    private SetF<AccessType> accessTypes;

    AccessLevel(SetF<AccessType> accessTypes) {
        this.accessTypes = accessTypes;
    }

    public boolean isAllowed(AccessType accessType) {
        return accessTypes.containsTs(accessType);
    }
}
