package ru.yandex.chemodan.app.persapi.acl;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class AccessLevelTest {
    @Test
    public void accessLevel() {
        Assert.isFalse(AccessLevel.DENY_ALL.isAllowed(AccessType.READ));
        Assert.isFalse(AccessLevel.DENY_ALL.isAllowed(AccessType.WRITE));

        Assert.isFalse(AccessLevel.WRITE_ONLY.isAllowed(AccessType.READ));
        Assert.isTrue(AccessLevel.WRITE_ONLY.isAllowed(AccessType.WRITE));

        Assert.isTrue(AccessLevel.READ_ONLY.isAllowed(AccessType.READ));
        Assert.isFalse(AccessLevel.READ_ONLY.isAllowed(AccessType.WRITE));

        Assert.isTrue(AccessLevel.READ_WRITE.isAllowed(AccessType.READ));
        Assert.isTrue(AccessLevel.READ_WRITE.isAllowed(AccessType.WRITE));
    }
}
