package ru.yandex.chemodan.app.persapi.acl;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.inside.bunker.BunkerClient;

/**
 * @author tolmalev
 */
@Configuration
public class FactAclContextConfiguration {
    @Bean
    public FactAclRegistry factAclRegistry(
            BunkerClient bunkerClient,
            @Value("${bunker.config.update.period}")
                    Duration updatePeriod)
    {
        return new FactAclRegistry(bunkerClient, updatePeriod);
    }

    @Bean
    public FactAclManager factAclManager(FactAclRegistry factAclRegistry) {
        return new FactAclManager(factAclRegistry);
    }
}
