package ru.yandex.chemodan.app.persapi.acl;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class FactAclRegistryTest {
    public static FactAclRegistry testRegistry() {
        return FactAclRegistry.createForTest(Cf
                .map(
                    "client1",
                    new ClassPathResourceInputStreamSource(FactAclRegistryTest.class, "example_acl_for_client1.json"),
                    "client2",
                    new ClassPathResourceInputStreamSource(FactAclRegistryTest.class, "example_acl_for_client2.json"),
                    "taxi",
                    new ClassPathResourceInputStreamSource(FactAclRegistryTest.class, "example_acl_for_taxi.json")));
    }

    @Test
    public void loadConfig() {
        testRegistry();
    }

    @Test
    public void byType() {
        FactAclRegistry acl = testRegistry();

        Assert.equals(AccessLevel.DENY_ALL, acl.getFullTypeAccessLevel("client1", "unknown"));
        Assert.equals(AccessLevel.DENY_ALL, acl.getFullTypeAccessLevel("unknown", "type1"));

        Assert.equals(AccessLevel.READ_ONLY, acl.getFullTypeAccessLevel("client1", "type1"));
        Assert.equals(AccessLevel.WRITE_ONLY, acl.getFullTypeAccessLevel("client1", "type2"));
        Assert.equals(AccessLevel.READ_WRITE, acl.getFullTypeAccessLevel("client1", "type3"));
    }

    @Test
    public void byTypeAndSource() {
        FactAclRegistry acl = testRegistry();

        Assert.equals(AccessLevel.DENY_ALL, acl.getTypeAndSourceAccessLevel("client2", "source1", "unknown"));
        Assert.equals(AccessLevel.DENY_ALL, acl.getTypeAndSourceAccessLevel("client2", "unknown", "type1"));
        Assert.equals(AccessLevel.DENY_ALL, acl.getTypeAndSourceAccessLevel("unknown", "source1", "type1"));

        Assert.equals(AccessLevel.READ_ONLY, acl.getTypeAndSourceAccessLevel("client2", "source1", "type1"));
        Assert.equals(AccessLevel.WRITE_ONLY, acl.getTypeAndSourceAccessLevel("client2", "source1", "type2"));
        Assert.equals(AccessLevel.READ_WRITE, acl.getTypeAndSourceAccessLevel("client2", "source1", "type3"));

        Assert.equals(AccessLevel.READ_ONLY, acl.getTypeAndSourceAccessLevel("client2", "source2", "type2"));
        Assert.equals(AccessLevel.WRITE_ONLY, acl.getTypeAndSourceAccessLevel("client2", "source2", "type3"));
        Assert.equals(AccessLevel.READ_WRITE, acl.getTypeAndSourceAccessLevel("client2", "source2", "type1"));
    }

    @Test
    public void getAccessibleSources() {
        FactAclRegistry acl = testRegistry();
        Assert.equals(acl.getAccessibleSources("taxi", "taxi", AccessType.READ), Cf.list("mail"));
    }

    @Test
    public void getTypeHash() {
        FactAclRegistry acl = testRegistry();
        Assert.equals(Cf.list("uid", "data.uid"), acl.getTypeHash("taxi", "taxi"));
    }

    @Test
    public void tvm() {
        FactAclRegistry acl = testRegistry();

        Assert.isTrue(acl.getTvmClientIds("client1").containsTs(1));
        Assert.isTrue(acl.getTvmClientIds("client1").containsTs(2));

        Assert.isEmpty(acl.getTvmClientIds("client2"));

        Assert.isTrue(acl.getTvmClientIds("taxi").containsTs(3));

        Assert.equals(Cf.set(1, 2, 3), acl.getAllTvmClientIds().unique());
    }
}
