package ru.yandex.chemodan.app.persapi.api;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.persapi.FactManager;
import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.chemodan.app.persapi.api.quick.YqlQuickFactsRetriever;
import ru.yandex.chemodan.app.persapi.api.yt.RetrieveFactsRunner;

/**
 * @author tolmalev
 */
@Configuration
@Import({
    FactApiYtContextConfiguration.class,
})
public class FactApiActionsContextConfiguration {

    @Bean
    public StoreFactAction storeFactAction(FactManager factManager, FactAclManager aclManager) {
        return new StoreFactAction(factManager, aclManager);
    }

    @Bean
    public StoreFactBatchAction storeFactBatchAction(FactManager factManager, FactAclManager aclManager) {
        return new StoreFactBatchAction(factManager, aclManager);
    }

    @Bean
    public RetrieveFactsAction retrieveFactsAction(RetrieveFactsRunner runner, FactAclManager aclManager) {
        return new RetrieveFactsAction(runner, aclManager);
    }

    @Bean
    public QuickRetrieveFactsAction quickRetrieveFactsAction(
            YqlQuickFactsRetriever retriever,
            @Value("${factapi.quick.max-uids}")
            long maxUids,
            FactAclManager aclManager)
    {
        return new QuickRetrieveFactsAction(retriever, maxUids, aclManager);
    }

    @Bean
    public PollYqlRunningAction pollYqlRunningAction(YqlQuickFactsRetriever retriever, FactAclManager aclManager) {
        return new PollYqlRunningAction(retriever, aclManager);
    }

}
