package ru.yandex.chemodan.app.persapi.api;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.yql.YqlOperationStatus;
import ru.yandex.chemodan.util.yql.YqlResponse;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
@BenderBindAllFields
@ActionResultPojo
public class OperationPojo {
    public final String operationId;
    public final Option<YqlOperationStatus> status;

    public OperationPojo(String operationId, Option<YqlOperationStatus> status) {
        this.operationId = operationId;
        this.status = status;
    }

    public OperationPojo(String operationId) {
        this(operationId, Option.empty());
    }

    public OperationPojo(YqlResponse response) {
        this(response.id, Option.of(response.status));
    }
}
