package ru.yandex.chemodan.app.persapi.api;

import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.chemodan.app.persapi.api.quick.YqlQuickFactsRetriever;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author yashunsky
 */

@Path(value = "/poll_operation", methods = {HttpMethod.GET, HttpMethod.POST})
public class PollYqlRunningAction extends TvmRequiredFactAction {

    @RequestParam
    private String id;

    private final YqlQuickFactsRetriever retriever;

    public PollYqlRunningAction(YqlQuickFactsRetriever retriever, FactAclManager aclManager) {
        super(aclManager);
        this.retriever = retriever;
    }

    @Override
    public Object executeInternal() {
        return new OperationPojo(retriever.getStatus(id));
    }
}
