package ru.yandex.chemodan.app.persapi.api;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.chemodan.app.persapi.api.quick.YqlQuickFactsRetriever;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.BoundByBender;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.Validate;

/**
 * @author yashunsky
 */

@Path(value = "/bass_get_facts", methods = {HttpMethod.PUT, HttpMethod.POST})
public class QuickRetrieveFactsAction extends TvmRequiredFactAction {

    @BoundByBender
    private Request request;
    @RequestParam
    private String path;

    private final long maxUidsCount;

    private final YqlQuickFactsRetriever retriever;

    public QuickRetrieveFactsAction(YqlQuickFactsRetriever retriever, long maxUidsCount, FactAclManager aclManager) {
        super(aclManager);
        this.maxUidsCount = maxUidsCount;
        this.retriever = retriever;
    }

    @Override
    public Object executeInternal() {
        Validate.le((long) request.users.size(), maxUidsCount);
        return new OperationPojo(retriever.run(request.users, path).id);
    }

    @BenderBindAllFields
    static final class Request {
        final ListF<Long> users;

        Request(ListF<Long> users) {
            this.users = users;
        }
    }
}
