package ru.yandex.chemodan.app.persapi.api;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.persapi.acl.AccessType;
import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.chemodan.app.persapi.api.yt.RetrieveFactsRunner;
import ru.yandex.chemodan.app.persapi.api.yt.RetrievementSettings;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author yashunsky
 */
@Path(value = "/retrieve", methods = {HttpMethod.PUT, HttpMethod.POST})
public class RetrieveFactsAction extends PublicCloneableActionSupport {
    @RequestParam
    private String clientId;

    @RequestParam
    private String type;
    @RequestParam(required = false)
    private ListF<String> source;
    @RequestParam
    private LocalDate day;
    @RequestParam
    private Option<Integer> daysBefore;
    @RequestParam
    private String path;

    private final RetrieveFactsRunner runner;
    private final FactAclManager aclManager;

    public RetrieveFactsAction(RetrieveFactsRunner runner, FactAclManager aclManager) {
        this.runner = runner;
        this.aclManager = aclManager;
    }

    @Override
    public Object execute() throws Exception {

        ListF<String> accessibleSources;

        if (source.isNotEmpty()) {
            source.forEach(s -> aclManager.checkAccess(clientId, s, type, AccessType.READ));
            accessibleSources = source;
        } else {
            accessibleSources = aclManager.isFullAccessAllowed(clientId, type, AccessType.READ)
                    ? Cf.list() : aclManager.getAccessibleSources(clientId, type, AccessType.READ);
        }

        ListF<String> hash = aclManager.getTypeHash(clientId, type);
        RetrievementSettings settings = new RetrievementSettings().withField(type, accessibleSources, hash);
        return new OperationPojo(
                runner.retrieve(day, daysBefore.getOrElse(0), settings, YPath.simple(path)).getId().toString());
    }
}
