package ru.yandex.chemodan.app.persapi.api;

import ru.yandex.chemodan.app.persapi.FactManager;
import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.chemodan.app.persapi.fact.Fact;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.RawResult;
import ru.yandex.commune.a3.action.parameter.bind.BoundByBender;

/**
 * @author tolmalev
 */
@Path(value = "/store", methods = {HttpMethod.PUT, HttpMethod.POST})
@RawResult
public class StoreFactAction extends TvmRequiredFactAction {
    @BoundByBender
    private Fact fact;

    private final FactManager factManager;

    public StoreFactAction(FactManager factManager, FactAclManager aclManager) {
        super(aclManager);
        this.factManager = factManager;
    }

    @Override
    public Object executeInternal() {
        factManager.storeFact(clientId, fact);
        return new OkPojo();
    }
}
