package ru.yandex.chemodan.app.persapi.api;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.persapi.FactManager;
import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.chemodan.app.persapi.fact.Fact;
import ru.yandex.chemodan.app.persapi.util.AxisBenderUtils;
import ru.yandex.chemodan.app.persapi.util.FactStoreFuture;
import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.RawResult;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
@Path(value = "/store_batch", methods = {HttpMethod.PUT, HttpMethod.POST})
@RawResult
public class StoreFactBatchAction extends TvmRequiredFactAction {
    private static final Logger logger = LoggerFactory.getLogger(StoreFactBatchAction.class);

    @SpecialParam
    private HttpServletRequestX servletRequestX;

    private final FactManager factManager;
    private final BenderJsonParser<Fact> factParser;

    public StoreFactBatchAction(FactManager factManager, FactAclManager aclManager) {
        super(aclManager);
        this.factManager = factManager;
        factParser = AxisBenderUtils.getA3BenderMapper().createParser(Fact.class);
    }

    @Override
    public Object executeInternal() {
        ListF<Fact> facts;
        try {
            facts = servletRequestX.getInputStreamX()
                    .readLines()
                    .map(factParser::parseJson);
        } catch (RuntimeException e) {
            throw new A3ExceptionWithStatus(ru.yandex.chemodan.util.web.ErrorNames.CAN_PARSE, e, HttpStatus.SC_400_BAD_REQUEST);
        }

        facts.forEach(fact -> factManager.checkStoreAccess(clientId, fact));
        facts.forEach(factManager::checkFactData);

        ListF<FactStoreFuture> futures
                = facts.map(fact -> factManager.storeFactAsync(clientId, fact));

        futures.forEach(factManager::waitFactStored);

        if (facts.isEmpty()) {
            logger.warn("Empty list of facts received");
        }

        return new CountPojo(facts.size());
    }

    @BenderBindAllFields
    @ActionResultPojo
    private static final class CountPojo {
        public final long count;

        private CountPojo(long count) {
            this.count = count;
        }
    }
}
