package ru.yandex.chemodan.app.persapi.api;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.ParameterDescriptor;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.ParameterBinder;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.TvmHeaders;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.passport.tvmauth.CheckedServiceTicket;

/**
 * @author tolmalev
 */
@AllArgsConstructor
public class TvmClientIdBinder implements ParameterBinder {
    private final Logger logger = LoggerFactory.getLogger(TvmClientIdBinder.class);

    private final Tvm2 tvm2;

    @Nullable
    @Override
    public Object createAndBind(WebRequest webRequest, ActionInvocationContext invocationContext,
            ParameterDescriptor parameterDescriptor)
    {
        return getClientIdFromTvm2Safe(webRequest);
    }

    private Option<Integer> getClientIdFromTvm2Safe(WebRequest request) {
        try {
            return request.getHeader(TvmHeaders.SERVICE_TICKET)
                    .map(tvm2::checkServiceTicket).map(CheckedServiceTicket::getSrc);
        } catch (Exception e) {
            logger.warn("Failed to parse tvm2 service ticket: {}", e);
            return Option.empty();
        }
    }
}
