package ru.yandex.chemodan.app.persapi.api;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.persapi.acl.FactAclManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author tolmalev
 */
public abstract class TvmRequiredFactAction extends PublicCloneableActionSupport {
    private final FactAclManager aclManager;

    @BindWith(TvmClientIdBinder.class)
    protected Option<Integer> tvmClientId;

    @RequestParam
    protected String clientId;

    protected TvmRequiredFactAction(FactAclManager aclManager) {
        this.aclManager = aclManager;
    }

    @Override
    public Object execute() throws Exception {
        aclManager.checkTvmAccess(clientId, tvmClientId);
        return executeInternal();
    }

    protected abstract Object executeInternal();
}
