import sys
import json
import itertools

ENCODING = 'utf-8'

VALID_TYPES = ['validated_ticket']


def print_safe(line):
    if (isinstance(line, unicode)):
        line = line.encode(ENCODING)
    print line


def do_decode(lines):
    for line in lines:
        yield json.loads(line)


def do_map(rows):
    for row in rows:
        if row.get('type') in VALID_TYPES:
            if '_stbx' in row:
                del row['_stbx']
            print_safe(json.dumps(row, ensure_ascii=False, encoding=ENCODING))


def do_reduce(rows):
    prev_row = {}

    for row in itertools.chain(rows, ({},)):
        if prev_row and prev_row != row:
            print json.dumps(prev_row)

        prev_row = row


if __name__ == '__main__':
    stream = sys.stdin
    stream = do_decode(stream)

    if len(sys.argv) >= 2 and sys.argv[1] == "map":
        do_map(stream)
    elif len(sys.argv) >= 2 and sys.argv[1] == "reduce":
        do_reduce(stream)
    else:
        print >> sys.stderr, "Please, specify proper map or reduce command to execute"
        sys.exit(1)
