package ru.yandex.chemodan.app.persapi.api.yt;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.yt.JacksonTableEntryTypeWithoutUtfEncoding;
import ru.yandex.chemodan.util.yt.YtRunnerBase;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.CommandSpec;
import ru.yandex.inside.yt.kosher.operations.specs.MapSpec;
import ru.yandex.inside.yt.kosher.tables.types.JacksonTableEntryType;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.codec.FastBase64Coder;

/**
 * @author yashunsky
 */
public class RetrieveFactsRunner extends YtRunnerBase {
    private final YPath logsRootPath;
    private final BenderSerializer<RetrievementSettings> serializer;

    public RetrieveFactsRunner(Yt yt, RetryPolicy retryPolicy, YPath rootPath, YPath logsRootPath) {
        super(yt, retryPolicy, rootPath, "retrieve_facts.py");
        this.logsRootPath = logsRootPath;
        this.serializer =
                Bender.cons(RetrievementSettings.class, BenderConfiguration.defaultConfiguration()).getSerializer();
    }

    public Operation retrieve(LocalDate by, int daysBefore, RetrievementSettings settings, YPath output) {

        String settingsJsonString = FastBase64Coder.encode(new String(serializer.serializeJson(settings)));

        CommandSpec mapCommandSpec = consPythonCmd(settingsJsonString, new JacksonTableEntryType(),
                settings.ensureAscii.getOrElse(false)
                        ? new JacksonTableEntryTypeWithoutUtfEncoding()
                        : new JacksonTableEntryType());

        ListF<YPath> logPaths = Cf.range(0, daysBefore + 1).map(d -> logsRootPath.child(by.minusDays(d).toString()))
                .filter(path -> yt.getWithRetries(() -> yt.cypress().exists(path)));

        uploadScripts();

        return yt.getWithRetries(() -> yt.operations()
                .mapAndGetOp(new MapSpec(logPaths, Cf.list(output.child(by.toString())), mapCommandSpec)));
    }
}
