package ru.yandex.chemodan.app.persapi.api.yt;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */

@BenderBindAllFields
public class RetrievementSettings {
    public final Option<Boolean> ensureAscii;
    public final Option<String> encoding;
    public final ListF<FieldSettings> fields;

    public RetrievementSettings(Option<Boolean> ensureAscii, Option<String> encoding,
            ListF<FieldSettings> fields)
    {
        this.ensureAscii = ensureAscii;
        this.encoding = encoding;
        this.fields = fields;
    }

    public RetrievementSettings() {
        this.ensureAscii = Option.empty();
        this.encoding = Option.empty();
        this.fields = Cf.list();
    }

    public RetrievementSettings withField(String type, ListF<String> sources, ListF<String> hash) {
        FieldSettings fieldSettings = new FieldSettings(type, sources, hash);
        return new RetrievementSettings(ensureAscii, encoding, fields.plus(fieldSettings));
    }

    public RetrievementSettings withFieldByType(String type) {
        return withField(type, Cf.list(), Cf.list());
    }

    public RetrievementSettings withFieldByTypeWithSources(String type, ListF<String> sources) {
        return withField(type, sources, Cf.list());
    }

    public RetrievementSettings withFieldByTypeWithHash(String type, ListF<String> hash) {
        return withField(type, Cf.list(), hash);
    }

    @BenderBindAllFields
    public static class FieldSettings {
        public final String type;
        public final ListF<String> sources;
        public final ListF<String> hash;

        public FieldSettings(String type, ListF<String> sources, ListF<String> hash) {
            this.type = type;
            this.sources = sources;
            this.hash = hash;
        }
    }
}
