package ru.yandex.chemodan.app.persapi.fact;

import org.joda.time.DateTime;

import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@ActionResultPojo
public class Fact extends DefaultObject {
    public final PassportUid uid;
    public final String source;
    public final String type;

    @BenderPart(name = "extract_time", strictName = true)
    public final DateTime extractTime;
    public final BenderJsonNode data;

    public Fact(PassportUid uid, String source, DateTime extractTime, String type, BenderJsonNode data) {
        this.uid = uid;
        this.source = source;
        this.extractTime = extractTime;
        this.type = type;
        this.data = data;
    }
}
