package ru.yandex.chemodan.app.persapi.log;

import org.joda.time.DateTime;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.persapi.fact.Fact;
import ru.yandex.chemodan.app.persapi.util.AxisBenderUtils;
import ru.yandex.chemodan.util.json.JsonNodeUtils;
import ru.yandex.chemodan.util.tskv.TskvUtils;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class FactLogUtilsTest {
    @Test
    public void badNewlines() {
        String factStr = "{\"uid\":\"23536426\",\"extract_time\":1484641388403,\"source\":\"mail\",\"type\":\"event-ticket\",\"data\":{\"uid\":\"23536426\",\"received-date\":\"1484641386\",\"lag\":\"1744\",\"subject\":\"Билет на Фантастические твари и где они обитают\",\"domain\":\"yandex-team.ru\",\"mid\":\"161003686678497796\",\"from-display-name\":\"Яндекс.Билеты\",\"from\":\"hello@yandex-team.ru\",\"stid\":\"104713.777387925.1915708166157729091041032391623\",\"facts\":[{\"kinopoisk_raw\":{\"selected_time\":1479330000,\"kinopoisk_original_titles\":[\"Fantastic Beasts and Where to Find Them 2\",\"Fantastic Beasts and Where to Find Them 3\",\"Fantastic Beasts and Where to Find Them\",\"Они и мы\",\"Where Beasts Dwell\",\"Eux et moi\",\"Hulk: Where Monsters Dwell\",\"Son o no son\",\"Who Are the DeBolts? [And Where Did They Get 19 Kids?]\",\"Они играли за Родину\",\"Un fantastico via vai\",\"Они\",\"Где-то плачет иволга...\",\"У моря, где мы играли\",\"Ennaku 20 Unakku 18\",\"The Fantasy Worlds of Irwin Allen\",\"...Aur Pyaar Ho Gaya\",\"E non se ne vogliono andare!\",\"And Then They Were Dead...\",\"Pricházejí z tmy\"],\"selected_rate\":7.691,\"kinopoisk_films_count\":20,\"kinopoisk_titles\":[\"Фантастические твари и где они обитают 2\",\"Фантастические твари и где они обитают 3\",\"Фантастические твари и где они обитают\",\"Они и мы\",\"Там, где обитают звери\",\"Они и я\",\"Халк: где обитают чудовища\",\"Они или не...\",\"Кто такие Де Болты? И где они взяли девятнадцать детей?\",\"Они играли за Родину\",\"Фантастические приезды и отъезды\",\"Они\",\"Где-то плачет иволга...\",\"У моря, где мы играли\",\"Где он, там и она\",\"Фантастические миры Ирвина Аллена\",\"И они полюбили друг друга\",\"И они не хотят уходить\",\"И затем они умерли\",\"Они приходят из тьмы\"],\"selected_url\":\"http://kinopoisk.ru/film/797840\",\"selected_title\":\"Фантастические твари и где они обитают\",\"kinopoisk_dates\":[\"2018-11-15\",\"2020-12-31\",\"2016-11-17\",\"1988\",\"2015\",\"2001\",\"2016-10-21\",\"1980\",\"1977-09-10\",\"2016\",\"2013-12-12\",\"2004\",\"1983-02-21\",\"1969\",\"2006\",\"1995-09-30\",\"1997-08-15\",\"1988-05-01\",\"2004-05-04\",\"1954-06-18\"],\"kinopoisk_rates\":[0,0,7.691,9,1,5.694,6,5.15,4.009,4.729,3.093,5.972,6.271,7.241,3.981,7.218,8.253,1.561,6.569],\"kinopoisk_urls\":[\"http://kinopoisk.ru/film/843479\",\"http://kinopoisk.ru/film/843772\",\"http://kinopoisk.ru/film/797840\",\"http://kinopoisk.ru/film/763454\",\"http://kinopoisk.ru/film/519064\",\"http://kinopoisk.ru/film/1007400\",\"http://kinopoisk.ru/film/143151\",\"http://kinopoisk.ru/film/4029\",\"http://kinopoisk.ru/film/762857\",\"http://kinopoisk.ru/film/775318\",\"http://kinopoisk.ru/film/602326\",\"http://kinopoisk.ru/film/44482\",\"http://kinopoisk.ru/film/521393\",\"http://kinopoisk.ru/film/252225\",\"http://kinopoisk.ru/film/28716\",\"http://kinopoisk.ru/film/78390\",\"http://kinopoisk.ru/film/369092\",\"http://kinopoisk.ru/film/331692\",\"http://kinopoisk.ru/film/101285\"]},\"start_date_ts\":1484752500,\"widget_subtype\":\"cinema\",\"origin\":\"pkpass\",\"ticket_number\":\"0341283\",\"title\":\"Фантастические твари и где они обитают\",\"seats\":[{\"seat\":5,\"row\":6},{\"seat\":6,\"row\":6}],\"num_seats\":2,\"iex_msg\":\"not eticket, but maybe\",\"special_parts\":[\"1.2\"],\"domain\":\"yandex-team.ru\",\"location\":{\"name\":\"ТИТАНИК СИНЕМА, ЕКАТЕРИНБУРГ\"},\"raw_data\":{\"backgroundColor\":\"#f6f5f3\",\"serialNumber\":\"1484641307206@d1ad129a-77a6-47fc-8a59-ee597f0341fa\",\"organizationName\":\"Yandex, LLC\",\"description\":\"Фантастические твари и где они обитают\",\"suppressStripShine\":true,\"foregroundColor\":\"#000000\",\"pass.strings\":{\"ru.lproj\":\"\\\"hall\\\" = \\\"ЗАЛ\\\";\\n\\\"row\\\" = \\\"РЯД\\\";\\n\\\"seats\\\" = \\\"МЕСТА\\\";\\n\\\"ticket_num\\\" = \\\"НОМЕР БИЛЕТА\\\";\\n\\\"price\\\" = \\\"ЦЕНА\\\";\\n\\\"scan_instructions\\\" = \\\"ИНСТРУКЦИЯ ПО ИСПОЛЬЗОВАНИЮ\\\";\\n\\\"ticket_refund\\\" = \\\"ВОЗВРАТ БИЛЕТА\\\";\\n\\\"complaints\\\" = \\\"В СЛУЧАЕ ВОЗНИКНОВЕНИЯ ВОПРОСОВ\\\";\\n\\\"complaints_value\\\" = \\\"8 800 555 5176\\\\ntickets@support.yandex.ru\\\";\\n\\\"venue_name\\\" = \\\"ТИТАНИК СИНЕМА, ЕКАТЕРИНБУРГ\\\";\\n\\\"event_name\\\" = \\\"Фантастические твари и где они обитают\\\";\\n\\\"start_date\\\" = \\\"18 ЯНВАРЯ\\\";\\n\\\"scan_instructions_value\\\" = \\\"Сообщите код кассиру в кинотеатре и получите входной билет.\\\";\\n\\\"ticket_refund_value\\\" = \\\"Для возврата билета свяжитесь с нашей службой поддержки либо перейдите по ссылке https://ya.cc/t/YXST5jKT0pPjJ\\\";\\n\\\"ticket_refund_attributed_value\\\" = \\\"Для возврата билета свяжитесь с нашей службой поддержки либо перейдите по ссылке https://ya.cc/t/YXST5jKT0pPjJ\\\";\",\"en.lproj\":\"\\\"hall\\\" = \\\"ЗАЛ\\\";\\n\\\"row\\\" = \\\"РЯД\\\";\\n\\\"seats\\\" = \\\"МЕСТА\\\";\\n\\\"ticket_num\\\" = \\\"НОМЕР БИЛЕТА\\\";\\n\\\"price\\\" = \\\"ЦЕНА\\\";\\n\\\"scan_instructions\\\" = \\\"ИНСТРУКЦИЯ ПО ИСПОЛЬЗОВАНИЮ\\\";\\n\\\"ticket_refund\\\" = \\\"ВОЗВРАТ БИЛЕТА\\\";\\n\\\"complaints\\\" = \\\"В СЛУЧАЕ ВОЗНИКНОВЕНИЯ ВОПРОСОВ\\\";\\n\\\"complaints_value\\\" = \\\"8 800 555 5176\\\\ntickets@support.yandex.ru\\\";\\n\\\"venue_name\\\" = \\\"ТИТАНИК СИНЕМА, ЕКАТЕРИНБУРГ\\\";\\n\\\"event_name\\\" = \\\"Фантастические твари и где они обитают\\\";\\n\\\"start_date\\\" = \\\"18 JANUARY\\\";\\n\\\"scan_instructions_value\\\" = \\\"Сообщите код кассиру в кинотеатре и получите входной билет.\\\";\\n\\\"ticket_refund_value\\\" = \\\"Для возврата билета свяжитесь с нашей службой поддержки либо перейдите по ссылке https://ya.cc/t/YXST5jKT0pPjJ\\\";\\n\\\"ticket_refund_attributed_value\\\" = \\\"Для возврата билета свяжитесь с нашей службой поддержки либо перейдите по ссылке https://ya.cc/t/YXST5jKT0pPjJ\\\";\"},\"labelColor\":\"#666666\",\"ignoresTimeZone\":false,\"eventTicket\":{\"backFields\":[{\"__type\":\"textField\",\"label\":\"scan_instructions\",\"value\":\"scan_instructions_value\",\"key\":\"scan-instructions\"},{\"attributedValue\":\"ticket_refund_attributed_value\",\"__type\":\"textField\",\"label\":\"ticket_refund\",\"value\":\"ticket_refund_value\",\"key\":\"ticket-refund\"},{\"__type\":\"textField\",\"label\":\"complaints\",\"value\":\"complaints_value\",\"key\":\"complaints\"},{\"__type\":\"textField\",\"label\":\"ticket_num\",\"value\":\"0341283\",\"key\":\"ticket-num\",\"dataDetectorTypes\":[]},{\"__type\":\"floatField\",\"numberStyle\":\"PKNumberStyleDecimal\",\"label\":\"price\",\"value\":300,\"currencyCode\":\"RUB\",\"key\":\"price\"}],\"secondaryFields\":[{\"__type\":\"textField\",\"label\":\"venue_name\",\"value\":\"event_name\",\"key\":\"event-venue\"}],\"headerFields\":[{\"__type\":\"textField\",\"label\":\"start_date\",\"value\":\"18:15\",\"key\":\"start-date\"}],\"primaryFields\":[],\"auxiliaryFields\":[{\"__type\":\"textField\",\"label\":\"row\",\"value\":\"6\",\"key\":\"row\"},{\"__type\":\"textField\",\"label\":\"seats\",\"value\":\"5, 6\",\"key\":\"seats\"},{\"__type\":\"textField\",\"label\":\"hall\",\"value\":\"Зал .7\",\"key\":\"hall\"}]},\"relevantDate\":\"2017-01-18T18:15+05:00\",\"formatVersion\":1,\"passTypeIdentifier\":\"pass.ru.yandex.mobile.tickets\",\"teamIdentifier\":\"477EAT77S3\",\"barcode\":{\"format\":\"PKBarcodeFormatQR\",\"messageEncoding\":\"iso-8859-1\",\"message\":\"0341283\"}},\"start_date\":\"18.01.2017 18:15:00\",\"kinopoisk_url\":\"http://kinopoisk.ru/film/797840\"}],\"entity\":\"event-ticket\",\"message-types\":\"\"}}";

        Fact fact = AxisBenderUtils.getA3BenderMapper().parseJson(Fact.class, factStr);

        String formatted = FactLogUtils.getFactLogString(fact);
        formatted = FactLogUtils.replaceField(formatted, "a", "c");
        formatted = FactLogUtils.replaceField(formatted, "a", "d");
        formatted = FactLogUtils.replaceField(formatted, "a", "e");
        formatted = FactLogUtils.replaceField(formatted, "a", "f");

        Assert.equals(fact.data.toString(), TskvUtils.extractTskv(formatted).getTs("data"));
    }

    @Test
    public void serializeFact() {
        Fact fact = new Fact(
                PassportUid.cons(123),
                "mail",
                new DateTime(123),
                "taxi",
                new JacksonJsonNodeWrapper(JsonNodeUtils.getNode("{\"uid\": 123}"))
        );
        String factLogString = FactLogUtils.getFactLogString(fact);
        Assert.assertContains(factLogString, "tskv\t");
        Assert.assertContains(factLogString, "tskv_format=axis-all-persfacts-log");
        Assert.assertContains(factLogString, "uid=123");
        Assert.assertContains(factLogString, "source=mail");
        Assert.assertContains(factLogString, "type=taxi");
        Assert.assertContains(factLogString, "extract_time=1970-01-01T03:00:00+03:00");
        Assert.assertContains(factLogString, "data={\\\"uid\\\":123}");
    }

    @Test
    public void hashSimpleFields() {
        String hashed = FactLogUtils.hashFields("tskv\ta=b\tc=d\teasd=f", Cf.set("a", "easd"));
        Assert.equals("tskv\ta=3e23e8160039594a33894f6564e1b1348bbd7a0088d42c4acb73eeaed59c009d\teasd=252f10c83610ebca1a059c0bae8255eba2f95be4d1d7bcfa89d7248a82d9f111\tc=d", hashed);
    }

    @Test
    public void hashComplexField() {
        String hashed = FactLogUtils.hashFields("tskv\tdata={\"a\":\"b\"}", Cf.set("data.a"));
        Assert.equals("tskv\tdata={\\\"a\\\":\\\"3e23e8160039594a33894f6564e1b1348bbd7a0088d42c4acb73eeaed59c009d\\\"}", hashed);
    }
}
