package ru.yandex.chemodan.app.persapi.util;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.chemodan.util.bender.BenderJsonNodeUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author tolmalev
 */
public class AxisBenderUtils {

    private static DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern("YYYY-MM-dd'T'HH:mm:ss.SSSSSSZZ");

    private static BenderMapper a3BenderMapper = new BenderMapper(new BenderConfiguration(new BenderSettings(),
            CustomMarshallerUnmarshallerFactoryBuilder
                    .cons()
                    .add(DateTime.class, new ReadableInstantConfigurableMarshaller(dateTimeFormatter))
                    .add(DateTime.class, new DateTimeIso8601OrMillisUnmarshaller())
                    .add(BenderJsonNode.class, new BenderJsonNodeUnmarshaller())
                    .build()));

    public static BenderMapper getA3BenderMapper() {
        return a3BenderMapper;
    }
}
