package ru.yandex.chemodan.app.persapi.util;

import java.text.ParseException;
import java.text.ParsePosition;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;

/**
 * @author tolmalev
 */
public class DateTimeIso8601OrMillisUnmarshaller extends SimpleTypeUnmarshallerSupport {
    @Override
    protected Object convert(String o) {
        if (StringUtils.isNumeric(o)) {
            return new DateTime(Long.parseLong(o), DateTimeZone.UTC);
        } else {
            try {
                return new DateTime(ISO8601Utils.parse(o, new ParsePosition(0)), DateTimeZone.UTC);
            } catch (ParseException e) {
                throw ExceptionUtils.translate(e);
            }
        }
    }
}
