package ru.yandex.chemodan.app.persapi.util;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DateTimeIso8601OrMillisUnmarshallerTest {

    @Test
    public void parseMillis() {
        DateTimeIso8601OrMillisUnmarshaller unmarshaller = new DateTimeIso8601OrMillisUnmarshaller();

        Assert.equals(new DateTime(12345, DateTimeZone.UTC), unmarshaller.convert("12345"));
    }

    @Test
    public void parseIso8601() {
        DateTimeIso8601OrMillisUnmarshaller unmarshaller = new DateTimeIso8601OrMillisUnmarshaller();

        Assert.equals(new DateTime(12345, DateTimeZone.UTC), unmarshaller.convert("1970-01-01T00:00:12.345Z"));
        Assert.equals(new DateTime(12345, DateTimeZone.UTC), unmarshaller.convert("1970-01-01T01:00:12.345+01:00"));
        Assert.equals(new DateTime(12345, DateTimeZone.UTC), unmarshaller.convert("1970-01-01T02:00:12.345+02:00"));
        Assert.equals(new DateTime(12345, DateTimeZone.UTC), unmarshaller.convert("1970-01-01T03:00:12.345+03:00"));
    }
}
