package ru.yandex.chemodan.app.persapi.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import com.google.common.util.concurrent.ListenableFuture;

import ru.yandex.chemodan.app.persapi.fact.Fact;
import ru.yandex.inside.logbroker.push.results.DataSendResult;

/**
 * @author tolmalev
 */
public class FactStoreFuture implements ListenableFuture<DataSendResult> {
    private final ListenableFuture<DataSendResult> future;
    private final Fact fact;

    public FactStoreFuture(ListenableFuture<DataSendResult> future, Fact fact) {
        this.future = future;
        this.fact = fact;
    }

    public Fact getFact() {
        return fact;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        future.addListener(runnable, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return future.isDone();
    }

    @Override
    public DataSendResult get() throws InterruptedException, ExecutionException {
        return future.get();
    }

    @Override
    public DataSendResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.get(timeout, unit);
    }
}
