package ru.yandex.chemodan.app.persapi.util;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.chemodan.app.persapi.acl.BunkerDynamicRegistryBase;
import ru.yandex.inside.bunker.BunkerClient;
import ru.yandex.misc.io.ByteArrayInputStreamSource;
import ru.yandex.misc.monica.core.name.FullMetricName;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author tolmalev
 */
public class SolomonPatternsRegistry extends BunkerDynamicRegistryBase<SolomonMetricPatterns> {

    public SolomonPatternsRegistry(BunkerClient bunkerClient, Duration updatePeriod) {
        super(bunkerClient, updatePeriod, "solomon");
    }

    @Override
    protected SolomonMetricPatterns parseNode(byte[] bytes) {
        ListF<Pattern2> patterns = new ByteArrayInputStreamSource(bytes)
                .readLines()
                .map(Pattern2::compile);

        return new SolomonMetricPatterns(patterns);
    }

    public Function1B<FullMetricName> getFilter(String environment) {
        return name -> exists(environment, name);
    }

    private boolean exists(String environment, FullMetricName name) {
        Option<SolomonMetricPatterns> patternsO = configByNode.getO(environment);
        if (!patternsO.isPresent()) {
            return false;
        }
        return patternsO.get().paterns.exists(p -> {
            return p.matches(name.asList().mkString("."));
        });
    }
}
