package ru.yandex.chemodan.app.factprocessor;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.logbroker.LbConsumerSettings2PrefixImpl;
import ru.yandex.chemodan.logbroker.PushClientFactory;
import ru.yandex.chemodan.logbroker.PushClientFactoryContextConfiguration;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.bunker.BunkerClient;
import ru.yandex.inside.logbroker.pull.consumer.LbConsumerAllDcSettingsProvider;
import ru.yandex.inside.logbroker.pull.consumer.LbConsumerSettings2;
import ru.yandex.inside.logbroker.pull.consumer.LbConsumerWorkerService;
import ru.yandex.inside.logbroker.pull.consumer.LbConsumers;
import ru.yandex.inside.logbroker.pull.consumer.LbLineListener;
import ru.yandex.inside.logbroker.pull.consumer.LbSimpleAsyncLineListener;
import ru.yandex.inside.logbroker.pull.consumer.SynchronousThreadPoolUtil;
import ru.yandex.inside.logbroker.pull.model.LbTopicFilter;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;
import ru.yandex.misc.parse.CommaSeparated;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        PushClientFactoryContextConfiguration.class,
})
public class FactProcessorConsumerContextConfiguration {

    @Value("${bunker.project}")
    private String bunkerProject;

    @Value("${bunker.host}")
    private String bunkerHost;

    @Bean
    public BunkerClient bunkerClient() {
        return new BunkerClient(bunkerProject, bunkerHost, ApacheHttpClient4.wrap(bunkerHttpClientConfigurator().configure()));
    }

    @Bean
    @OverridableValuePrefix("bunker")
    public HttpClientConfigurator bunkerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public FactSplitter factSplitter(PushClientFactory factory) {
        return new FactSplitter(bunkerClient(), factory);
    }

    @Value("${logbroker.listener.executor.queue-timeout}")
    private Duration listenerQueueTimeout;

    @Value("${logbroker.listener.executor.total-thread-count}")
    private int listenerThreadsTotalCount;

    @Value("${logbroker.idents-to-exclude}")
    private CommaSeparated excludeIdents;

    @Value("${logbroker.pull.logtype}")
    private String logtype;

    @Bean
    protected LbLineListener mainLbConsumerListener() {
        return new LbSimpleAsyncLineListener(factSplitter(null),
                SynchronousThreadPoolUtil.listenerExecutor(listenerQueueTimeout, listenerThreadsTotalCount)
        );
    }

    @Bean
    @OverridableValuePrefix("facts-main")
    protected LbConsumerSettings2 mainLbConsumerSettings() {
        return new LbConsumerSettings2PrefixImpl("facts",
                new LbTopicFilter()
                        .withIdentsToExclude(excludeIdents.list)
                        .withLogType(logtype)
        );
    }

    @Bean
    public LbConsumerWorkerService mainLbConsumerWorkerService(
            @Value("${logbroker.pull.consumer-count}") int consumerCount)
    {
        return new LbConsumerWorkerService(
                new LbConsumers(new LbConsumerAllDcSettingsProvider(mainLbConsumerSettings()), mainLbConsumerListener())
                        .fixedCount(consumerCount)
        );
    }
}
