package ru.yandex.chemodan.app.factprocessor;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.factprocessor.bass.FactProcessorBassConsumerContextConfiguration;
import ru.yandex.chemodan.app.persapi.acl.FactAclContextConfiguration;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.commune.script.cosher.nashorn.NashornInterpreterFactory;
import ru.yandex.commune.script.cosher.server.ScriptTelnetServer;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        FactAclContextConfiguration.class,
        FactProcessorConsumerContextConfiguration.class,
        FactProcessorBassConsumerContextConfiguration.class,
        A3JettyContextConfiguration.class
})
public class FactProcessorContextConfiguration {
    @Bean
    public DiskAppVersion version() {
        return DiskAppVersion.VERSION;
    }

    @Bean
    public ScriptTelnetServer scriptTelnetServer() {
        return new ScriptTelnetServer(new NashornInterpreterFactory(), 8080, true);
    }
}
