package ru.yandex.chemodan.app.factprocessor.bass;

import java.io.IOException;
import java.net.URI;

import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.apache.v4.Abstract200ExtendedResponseHandler;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author tolmalev
 */
public class BassClient {
    private final String host;
    private final HttpClient httpClient;

    private final BenderJsonParser<BassUsersCheckResponse> responseParser =
            Bender.parser(BassUsersCheckResponse.class);
    private final BenderJsonSerializer<BassUsersCheckRequest> requestSerializer =
            Bender.serializer(BassUsersCheckRequest.class);

    private final SyncFailsafe failsafe;

    public BassClient(String host, HttpClient httpClient) {
        this.host = host;
        this.httpClient = httpClient;

        RetryPolicy policy = new RetryPolicy();
        policy.withMaxRetries(10);
        policy.retryOn(e -> true);

        failsafe = Failsafe.with(policy);
    }

    public ListF<String> checkUids(ListF<String> uids) {
        try {
            return failsafe.get(() -> checkUidsImpl(uids));
        } catch (FailsafeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpException) {
                HttpException httpE = (HttpException) cause;
                if (httpE.getStatusCode().isPresent() && HttpStatus.is4xx(httpE.getStatusCode().get())) {
                    return Cf.list();
                }
            }
            throw ExceptionUtils.throwException(cause);
        }
    }

    private ListF<String> checkUidsImpl(ListF<String> uids) {
        ListF<Long> longUids = uids.flatMap(Cf.Long.parseSafeF());

        URI uri = UriBuilder
                .cons(host)
                .appendPath("check-users")
                .build();

        HttpPost post = new HttpPost(uri);
        post.addHeader("Content-type", "application/json");
        post.setEntity(new ByteArrayEntity(requestSerializer.serializeJson(new BassUsersCheckRequest(longUids))));

        return ApacheHttpClientUtils.execute(post, httpClient, new Abstract200ExtendedResponseHandler<ListF<String>>() {
            @Override
            protected ListF<String> handle200Response(HttpResponse response)
                    throws IOException
            {
                return responseParser
                        .parseJson(InputStreamSourceUtils.wrap(response.getEntity().getContent()))
                        .getKnownUids();
            }
        });
    }
}
