package ru.yandex.chemodan.app.factprocessor.bass;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class BassClientTest {
    private BassClient bassClient = new BassClient(
            "http://push-beta.n.yandex-team.ru",
            ApacheHttpClientUtils.singleConnectionClient(Option.of(Timeout.seconds(1)))
    );

    static {
        TestHelper.initialize();
    }

    // test server throws 5xx and 4xx sometimes so we need to ignore this test

    @Test
    public void empty() {
        bassClient.checkUids(Cf.list());
    }

    @Test
    public void simple() {
        bassClient.checkUids(Cf.list("12345"));
    }

    @Test
    public void several() {
        Assert.in("123456", bassClient.checkUids(Cf.list("123456", "7890123")));
    }

    @Test
    public void notString() {
        bassClient.checkUids(Cf.list("sadfa"));
    }
}
