package ru.yandex.chemodan.app.factprocessor.bass;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.center.client.rest.v1.internal.bind.Convertible;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class BassUsersCheckResponse implements Convertible<ListF<String>> {
    public final ListF<UserStatus> users;

    public BassUsersCheckResponse(ListF<UserStatus> users) {
        this.users = users;
    }

    public ListF<String> getKnownUids() {
        return users
                .filter(s -> "known".equals(s.status))
                .map(s -> Long.toString(s.uid));
    }

    @Override
    public ListF<String> convert() {
        return getKnownUids();
    }

    @BenderBindAllFields
    public static class UserStatus {
        public final long uid;
        public final String status;

        public UserStatus(long uid, String status) {
            this.uid = uid;
            this.status = status;
        }
    }
}
