package ru.yandex.chemodan.app.balancer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.balancer.selection.UrlSelectionStrategy;
import ru.yandex.chemodan.ping.HostsManager;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author nshmakov
 */
public class BalancerImpl implements Balancer {

    private static final Logger logger = LoggerFactory.getLogger(BalancerImpl.class);

    private final DynamicProperty<Integer> selectionLimit;
    @Value("${uploader-balancer.uploader.slb.url}")
    private String slbUrl;

    @Autowired
    private UrlSelectionStrategy selectionStrategy;
    @Autowired
    private HostsManager<MapF<LoadingStatusStrategyType, Long>> hostsManager;
    @Autowired
    private LoadingStatusSummarizingStrategy loadingStatusSummarizingStrategy;

    public BalancerImpl() {
        this(10);
    }

    public BalancerImpl(int defaultSelectionLimit) {
        this.selectionLimit = new DynamicProperty<>("uploader-balancer.uploader.hosts.selection-limit", defaultSelectionLimit);
    }

    @Override
    public String selectUploader() {
        MapF<String, MapF<LoadingStatusStrategyType, Long>> uploadersLoadingStatus =
                hostsManager.getAvailableHostsResults();
        if (uploadersLoadingStatus.isEmpty()) {
            logger.warn("Uploaders list is empty. Forward to slb: {}", slbUrl);
            return slbUrl;
        } else {
            MapF<String, Long> uploadersWithSummarizedLoadingStatus = loadingStatusSummarizingStrategy
                    .summarizeLoadingStatus(uploadersLoadingStatus);
            ListF<String> relaxedUploaders = uploadersWithSummarizedLoadingStatus.entries().sortedBy2().map(Tuple2.<String, Long>get1F())
                    .take(selectionLimit.get());
            return selectionStrategy.select(relaxedUploaders);
        }
    }

    @Override
    public MapF<String, MapF<LoadingStatusStrategyType, Long>> getUploadersLoadingStatus() {
        return hostsManager.getAvailableHostsResults();
    }

    public void setSelectionStrategy(UrlSelectionStrategy selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
    }

    public void setHostsManager(HostsManager<MapF<LoadingStatusStrategyType, Long>> hostsManager) {
        this.hostsManager = hostsManager;
    }

    public void setSlbUrl(String slbUrl) {
        this.slbUrl = slbUrl;
    }

    public void setLoadingStatusSummarizingStrategy(LoadingStatusSummarizingStrategy loadingStatusSummarizingStrategy) {
        this.loadingStatusSummarizingStrategy = loadingStatusSummarizingStrategy;
    }
}

