package ru.yandex.chemodan.app.balancer;


import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.balancer.config.AdminContextConfiguration;
import ru.yandex.chemodan.app.balancer.config.BalancerDaemonContextConfiguration;
import ru.yandex.chemodan.app.balancer.config.CoreContextConfiguration;
import ru.yandex.chemodan.app.balancer.config.ServletContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author nshmakov
 */
public class BalancerMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        new BalancerMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "uploader-balancer");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(BalancerDaemonContextConfiguration.class,
                CoreContextConfiguration.class,
                ServletContextConfiguration.class,
                AdminContextConfiguration.class,
                ChemodanCommonContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        super.configureLogger();

        Log4jHelper.configureHttpClientLoggerLevel(Level.INFO);

    }
}
