package ru.yandex.chemodan.app.balancer;

import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author nshmakov
 */
public class LoadingStatusCoefficientsHolder {

    private final DynamicProperty<Double> laCoefficient = new DynamicProperty<Double>("la-coefficient", 1.);
    private final DynamicProperty<Double> contentCoefficient = new DynamicProperty<Double>("content-coefficient", 1.);
    private final DynamicProperty<Double> networkIoCoefficient = new DynamicProperty<Double>("network-io-coefficient", 1.);
    private final DynamicProperty<Double> diskIoCoefficient = new DynamicProperty<Double>("disk-io-coefficient", 1.);
    private final DynamicProperty<Double> diskIopsCoefficient = new DynamicProperty<Double>("disk-iops-coefficient", 1.);
    private final DynamicProperty<Double> queueSizeUserCoefficient = new DynamicProperty<Double>("queue-size-user-coefficient", 1.);
    private final DynamicProperty<Double> expUserQueueInitialCoefficient = new DynamicProperty<Double>("exp-user-queue-initial-coefficient", 1.);
    private final DynamicProperty<Double> expUserQueueInProgressCoefficient = new DynamicProperty<Double>("exp-user-queue-in-progress-coefficient", 1.);
    private final DynamicProperty<Double> queueSizeMulcaCoefficient = new DynamicProperty<Double>("queue-size-mulca-coefficient", 1.);

    public double getLaCoefficient() {
        return laCoefficient.get();
    }

    public double getContentCoefficient() {
        return contentCoefficient.get();
    }

    public double getNetworkIoCoefficient() {
        return networkIoCoefficient.get();
    }

    public double getDiskIoCoefficient() {
        return diskIoCoefficient.get();
    }

    public double getDiskIopsCoefficient() {
        return diskIopsCoefficient.get();
    }

    public double getQueueSizeUserCoefficient() {
        return queueSizeUserCoefficient.get();
    }

    public double getQueueSizeMulcaCoefficient() {
        return queueSizeMulcaCoefficient.get();
    }

    public double getExpUserQueueInitialCoefficient() {
        return expUserQueueInitialCoefficient.get();
    }

    public double getExpUserQueueInProgressCoefficient() {
        return expUserQueueInProgressCoefficient.get();
    }
}
