package ru.yandex.chemodan.app.balancer;

import java.util.Collections;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.when;
import static ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType.CONTENT;
import static ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType.DISK_IO;
import static ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType.DISK_IOPS;
import static ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType.LA;
import static ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType.NETWORK_IO;
import static ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType.QUEUE_SIZE_USER;

/**
 * @author nshmakov
 */
@RunWith(MockitoJUnitRunner.class)
public class LoadingStatusSummarizingStrategyTest {

    private LoadingStatusSummarizingStrategy sut = new LoadingStatusSummarizingStrategy();
    @Mock
    private LoadingStatusCoefficientsHolder coefficientsHolderMock;
    @Mock
    private LoadingStatusTypesHolder loadingStatusTypesHolderMock;

    private double laCoef = 1.5;
    private double contentCoef = 2;
    private double networkIoCoef = 2.5;
    private double diskIoCoef = 3;
    private double diskIopsCoef = 0.5;
    private double queueUserCoef = 10;

    @Before
    public void init() {
        sut.setLoadingStatusCoefficientHolder(coefficientsHolderMock);
        sut.setLoadingStatusTypesHolder(loadingStatusTypesHolderMock);
        when(coefficientsHolderMock.getLaCoefficient()).thenReturn(laCoef);
        when(coefficientsHolderMock.getContentCoefficient()).thenReturn(contentCoef);
        when(coefficientsHolderMock.getNetworkIoCoefficient()).thenReturn(networkIoCoef);
        when(coefficientsHolderMock.getDiskIoCoefficient()).thenReturn(diskIoCoef);
        when(coefficientsHolderMock.getDiskIopsCoefficient()).thenReturn(diskIopsCoef);
        when(coefficientsHolderMock.getQueueSizeUserCoefficient()).thenReturn(queueUserCoef);
    }

    @Test
    public void shouldSummarizeStatuses() {
        MapF<LoadingStatusStrategyType, Long> stat = Cf.<LoadingStatusStrategyType, Long>map()
                .plus1(LA, 1000L)
                .plus1(CONTENT, 500L)
                .plus1(NETWORK_IO, 2000L)
                .plus1(DISK_IO, 5000L)
                .plus1(DISK_IOPS, 10000L)
                .plus1(QUEUE_SIZE_USER, 10000L);

        when(loadingStatusTypesHolderMock.getTypes()).thenReturn(stat.keys());

        MapF<String, Long> actual = sut.summarizeLoadingStatus(Cf.map("host", stat));

        Assert.equals(Cf.map("host", 127500L), actual);
    }

    @Test
    public void shouldSumOnlySpecifiedStrategies() {
        MapF<LoadingStatusStrategyType, Long> stat = Cf.<LoadingStatusStrategyType, Long>map()
                .plus1(LA, 1000L)
                .plus1(CONTENT, 500L)
                .plus1(NETWORK_IO, 2000L)
                .plus1(DISK_IO, 5000L)
                .plus1(DISK_IOPS, 10000L);
        when(loadingStatusTypesHolderMock.getTypes()).thenReturn(Collections.singletonList(LA));

        MapF<String, Long> actual = sut.summarizeLoadingStatus(Cf.map("host", stat));

        Assert.equals(Cf.map("host", 1500L), actual);
    }
}
