package ru.yandex.chemodan.app.balancer.admin;

import java.util.Map;
import java.util.TreeMap;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function3;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author nshmakov
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class UploaderLoadingStatus extends DefaultObject {

    public final String url;
    public final long summarizedLoadingStatus;
    public final Map<LoadingStatusStrategyType, Long> rawLoadingStatus;

    public UploaderLoadingStatus(
            String url,
            long summarizedLoadingStatus,
            MapF<LoadingStatusStrategyType, Long> rawLoadingStatus)
    {
        this.url = url;
        this.summarizedLoadingStatus = summarizedLoadingStatus;
        this.rawLoadingStatus = new TreeMap<LoadingStatusStrategyType, Long>(rawLoadingStatus);
    }

    public static final Function3<String, Long, MapF<String, MapF<LoadingStatusStrategyType, Long>>, UploaderLoadingStatus> consF =
            (url, summarizedLoadingStatus, rawStatueses) -> new UploaderLoadingStatus(url, summarizedLoadingStatus, rawStatueses.getTs(url));
}
