package ru.yandex.chemodan.app.balancer.admin;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.misc.test.Assert;

/**
 * @author nshmakov
 */
public class UploaderLoadingStatusUtilsTest {

    @Test
    public void shouldSortByValue() {
        MapF<String, Long> status = Cf.map("host2", 2L)
                .plus1("host1", 1L)
                .plus1("host3", 3L);
        MapF<LoadingStatusStrategyType, Long> rawStatus1 = Cf.map(LoadingStatusStrategyType.LA, 1L);
        MapF<LoadingStatusStrategyType, Long> rawStatus2 = Cf.map(LoadingStatusStrategyType.LA, 2L);
        MapF<LoadingStatusStrategyType, Long> rawStatus3 = Cf.map(LoadingStatusStrategyType.LA, 3L);

        ListF<UploaderLoadingStatus> actual = UploaderLoadingStatusUtils.sortedByLoadingStatus(status,
                Cf.map("host1", rawStatus1, "host2", rawStatus2).plus1("host3", rawStatus3));

        ListF<UploaderLoadingStatus> expected = Cf.list(
                new UploaderLoadingStatus("host1", 1L, rawStatus1),
                new UploaderLoadingStatus("host2", 2L, rawStatus2),
                new UploaderLoadingStatus("host3", 3L, rawStatus3)
        );
        Assert.equals(expected, actual);
    }

    @Test
    public void shouldAcceptEmptyMap() {
        Assert.isEmpty(UploaderLoadingStatusUtils.sortedByLoadingStatus(Cf.<String, Long>map(),
                Cf.<String, MapF<LoadingStatusStrategyType, Long>>map()));
    }
}
