package ru.yandex.chemodan.app.balancer.admin;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.balancer.Balancer;
import ru.yandex.chemodan.app.balancer.LoadingStatusSummarizingStrategy;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.misc.web.servlet.SimpleTableServlet;
import ru.yandex.misc.web.util.Table;

/**
 * @author nshmakov
 */
public class UploadersLoadingStatusServlet extends SimpleTableServlet<UploaderLoadingStatus> {

    @Autowired
    private Balancer balancer;
    @Autowired
    private LoadingStatusSummarizingStrategy loadingStatusSummarizingStrategy;

    @Override
    protected Table<UploaderLoadingStatus> getTable() {
        return new Table<UploaderLoadingStatus>() {
            public ListF<Column<UploaderLoadingStatus>> getColumns() {
                return Cf.list(new Column<UploaderLoadingStatus>() {
                    public String getName() {
                        return "Uploader URL";
                    }
                    public Object getValue(UploaderLoadingStatus row) {
                        return row.url;
                    }
                }, new Column<UploaderLoadingStatus>() {
                    public String getName() {
                        return "Summarized Loading Status";
                    }
                    public Object getValue(UploaderLoadingStatus row) {
                        return row.summarizedLoadingStatus;
                    }
                }, new Column<UploaderLoadingStatus>() {
                   public String getName() {
                       return "Raw Loading Status";
                   }
                   public Object getValue(UploaderLoadingStatus row) {
                       return row.rawLoadingStatus;
                   }
               });
            }
            public ListF<UploaderLoadingStatus> getRows() {
                MapF<String, MapF<LoadingStatusStrategyType, Long>>
                        rawLoadingStatus = balancer.getUploadersLoadingStatus();
                MapF<String, Long> summarizedLoadingStatus =
                        loadingStatusSummarizingStrategy.summarizeLoadingStatus(rawLoadingStatus);
                return UploaderLoadingStatusUtils.sortedByLoadingStatus(summarizedLoadingStatus, rawLoadingStatus);
            }
        };
    }
}
