<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        exclude-result-prefixes="z xsl"
        version="2.0">

    <xsl:import href="./../../../../commune/admin/web/common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <table class="fixed-table table table-striped table-condensed table-bordered">
                <tr>
                    <th>Uploader URL</th>
                    <th>Summarized Loading Status</th>
                    <th>Raw Loading Status</th>
                </tr>
                <xsl:for-each select="status">
                    <tr>
                        <td><xsl:value-of select="url"/></td>
                        <td><xsl:value-of select="summarized-loading-status"/></td>
                        <td>
                            <xsl:for-each select="raw-loading-status">
                                <b><xsl:value-of select="key"/></b>: <xsl:value-of select="value"/>;
                            </xsl:for-each>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>
        </div>
    </xsl:template>

</xsl:stylesheet>
