package ru.yandex.chemodan.app.balancer.admin;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.balancer.Balancer;
import ru.yandex.chemodan.app.balancer.LoadingStatusSummarizingStrategy;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author nshmakov
 */
@ActionContainer
public class UploadersLoadingStatusZscript {

    @Autowired
    private Balancer balancer;
    @Autowired
    private LoadingStatusSummarizingStrategy loadingStatusSummarizingStrategy;

    @ZAction(defaultAction = true)
    @Path("/uploaders-status")
    public UploadersLoadingStatus index() {
        MapF<String, MapF<LoadingStatusStrategyType, Long>>
                rawLoadingStatus = balancer.getUploadersLoadingStatus();
        MapF<String, Long> summarizedLoadingStatus =
                loadingStatusSummarizingStrategy.summarizeLoadingStatus(rawLoadingStatus);
        return new UploadersLoadingStatus(summarizedLoadingStatus, rawLoadingStatus);
    }

    @Bendable
    @XmlRootElement(name = "content")
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class UploadersLoadingStatus {

        public final ListF<UploaderLoadingStatus> status;

        public UploadersLoadingStatus(MapF<String, Long> summarizedStatus,
                MapF<String, MapF<LoadingStatusStrategyType, Long>> rawStatus)
        {
            this.status = UploaderLoadingStatusUtils.sortedByLoadingStatus(summarizedStatus, rawStatus);
        }
    }
}
