package ru.yandex.chemodan.app.balancer.client;

import org.glassfish.grizzly.http.Method;
import org.junit.Test;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.chemodan.util.test.StubServerUtils;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Action.stringContent;
import static com.xebialabs.restito.semantics.Condition.method;

/**
 * @author nshmakov
 */
public class UploaderClientTest {

    private UploaderClient sut = new UploaderClient(ApacheHttpClientUtils.singleConnectionClient(Timeout.seconds(1)));

    @Test
    public void shouldReturnUploaderLoadingStatus() {
        StubServerUtils.withStubServer((port, server) -> {
            sut.setPort(port);

            whenHttp(server)
                    .match(method(Method.GET).uri("/loading-status"))
                    .then(stringContent("{\"NETWORK_IO\":0,\"LA\":306,\"DISK_IOPS\":101,\"DISK_IO\":12}"));
            MapF<LoadingStatusStrategyType, Long> actual = sut.ping("localhost");
            Assert.equals(4, actual.size());
            Assert.equals(12L, actual.getTs(LoadingStatusStrategyType.DISK_IO));
            Assert.equals(101L, actual.getTs(LoadingStatusStrategyType.DISK_IOPS));
            Assert.equals(306L, actual.getTs(LoadingStatusStrategyType.LA));
            Assert.equals(0L, actual.getTs(LoadingStatusStrategyType.NETWORK_IO));
        });
    }
}
