package ru.yandex.chemodan.app.balancer.config;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.balancer.admin.UploadersLoadingStatusServlet;
import ru.yandex.chemodan.app.balancer.admin.UploadersLoadingStatusZscript;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author nshmakov
 */
@Configuration
public class AdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @Bean
    public UploadersLoadingStatusZscript uploadersLoadingStatusZscript() {
        return new UploadersLoadingStatusZscript();
    }

    @Bean
    public UploadersLoadingStatusServlet uploadersLoadingStatusServlet() {
        return new UploadersLoadingStatusServlet();
    }

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage("Uploaders Status", uploadersLoadingStatusZscript());
        adminApp.registerPlain("/uploaders-status", uploadersLoadingStatusServlet());
    }
}
