package ru.yandex.chemodan.app.balancer.config;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.balancer.servlet.HttpProxyServlet;
import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.chemodan.uploader.status.MaintenanceFileChecker;
import ru.yandex.chemodan.uploader.web.control.PingDiskServlet;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author nshmakov
 * @author metal
 */
@Configuration
public class BalancerDaemonContextConfiguration {

    @Bean
    public SingleWarJetty balancerJetty(
            @Value("${uploader-balancer.http.maxThreads}") int maxThreads,
            @Value("${uploader-balancer.http.maxQueueLength}") int maxQueueLength,
            @Value("${uploader-balancer.http.port}") int port,
            @Value("${uploader-balancer.http.serverSocketBacklog}") int socketBacklog,
            @Value("${uploader-balancer.socket.maxIdleTime}") Duration maxIdleTime,
            HttpProxyServlet httpProxyServlet)
    {
        SingleWarJetty jetty = new DiskJetty("kldlb");
        jetty.setHttpPort(port);
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setAcceptQueueSize(socketBacklog);
        jetty.setCopyBeanPostprocessors(true);
        jetty.setLookupServletsInContext(false);
        jetty.setMaxIdleTimeMillis((int) maxIdleTime.getMillis());
        jetty.setRequestLogFactory(DiskLog4jRequestLog.consF());

        jetty.addServletMapping("/*", httpProxyServlet);
        jetty.addServletMapping("/ping", pingBalancerServlet());

        jetty.initialize();
        return jetty;
    }

    @Bean
    public MaintenanceFileChecker maintenanceFileChecker(AppName appName) {
        return new MaintenanceFileChecker(appName);
    }

    @Bean
    public PingDiskServlet pingBalancerServlet() {
        return new PingDiskServlet();
    }
}
