package ru.yandex.chemodan.app.balancer.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.http.client.HttpClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.balancer.Balancer;
import ru.yandex.chemodan.app.balancer.BalancerImpl;
import ru.yandex.chemodan.app.balancer.LoadingStatusCoefficientsHolder;
import ru.yandex.chemodan.app.balancer.LoadingStatusSummarizingStrategy;
import ru.yandex.chemodan.app.balancer.LoadingStatusTypesHolder;
import ru.yandex.chemodan.app.balancer.client.UploaderClient;
import ru.yandex.chemodan.app.balancer.selection.UrlSelectionStrategy;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.UploaderRequestRetryHandler;
import ru.yandex.chemodan.ping.HostsManager;
import ru.yandex.chemodan.ping.HostsProvider;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.version.Version;

/**
 * @author nshmakov
 */
@Configuration
@Import(ConductorContextConfiguration.class)
public class CoreContextConfiguration {

    @Autowired
    private Conductor conductor;
    @Value("${uploader-balancer.uploader.pingPoolSize}")
    private int pingPoolSize;
    @Value("${uploader-balancer.conductor.uploaderHosts}")
    private String uploaderHosts;
    @Value("${uploader-balancer.conductor.uploader.hosts.updateDelay}")
    private Duration uploaderHostsUpdateDelay;
    @Value("${uploader-balancer.ping.delay}")
    private Duration pingDelay;

    @Bean
    public UploaderClient uploaderClient() {
        return new UploaderClient(uploaderPingHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("uploader_ping")
    public HttpClientConfigurator uploaderPingHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public HostsProvider uploadersHostsProvider() {
        HostsProvider hostsProvider = new HostsProvider(conductor, uploaderHosts);
        hostsProvider.setSleepBeforeFirstRun(false);
        hostsProvider.setDelay(uploaderHostsUpdateDelay);
        return hostsProvider;
    }

    @Bean
    public HostsManager<MapF<LoadingStatusStrategyType, Long>> hostsManager() {
        HostsManager<MapF<LoadingStatusStrategyType, Long>> hostsManager =
                new HostsManager<MapF<LoadingStatusStrategyType, Long>>(
                        uploadersHostsProvider(), uploaderClient(), uploadersPingPool());
        hostsManager.setSleepBeforeFirstRun(false);
        hostsManager.setDelay(pingDelay);
        return hostsManager;
    }

    @Bean
    public Balancer balancer() {
        return new BalancerImpl();
    }

    @Bean
    public UrlSelectionStrategy hostSelectionStrategy() {
        return new UrlSelectionStrategy();
    }

    @Bean
    public ExecutorService uploadersPingPool() {
        return Executors.newFixedThreadPool(pingPoolSize);
    }

    @Bean
    public HttpClient proxyServletHttpClient() {
        return proxyServletHttpClientConfigurator().configure();
    }

    @Bean
    @OverridableValuePrefix("uploader-balancer")
    public HttpClientConfigurator proxyServletHttpClientConfigurator() {
        return new HttpClientConfigurator() {
            @Override
            public ApacheHttpClientUtils.Builder createBuilder() {
                return super.createBuilder().withRequestRetryHandler(new UploaderRequestRetryHandler());
            }
        };
    }

    @Bean
    public LoadingStatusTypesHolder loadingStatusTypesHolder() {
        return new LoadingStatusTypesHolder();
    }

    @Bean
    public LoadingStatusSummarizingStrategy loadingStatusSummarizingStrategy() {
        return new LoadingStatusSummarizingStrategy();
    }

    @Bean
    public LoadingStatusCoefficientsHolder loadingStatusCoefficientsHolder() {
        return new LoadingStatusCoefficientsHolder();
    }

    @Bean
    public Version version() {
        return DiskAppVersion.VERSION;
    }
}
