package ru.yandex.chemodan.app.bazingaload;

import ru.yandex.chemodan.app.bazingaload.tasks.AbstractLoadTask;
import ru.yandex.chemodan.app.bazingaload.tasks.CpuLoadTask;
import ru.yandex.chemodan.app.bazingaload.tasks.DummyPayload;
import ru.yandex.chemodan.app.bazingaload.tasks.MultiplicationTask;
import ru.yandex.chemodan.app.bazingaload.tasks.QuickMovePostProcessTask;
import ru.yandex.chemodan.app.bazingaload.tasks.SleepTask;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.random.Random2;

public class TasksManager {
    private BazingaTaskManager bazingaTaskManager;
    private DynamicProperty<Integer> payloadSizeKb = new DynamicProperty<>("tasks--payload-size", 200);

    public TasksManager(BazingaTaskManager bazingaTaskManager)
    {
        this.bazingaTaskManager = bazingaTaskManager;
    }

    public void addSleepTask() {
        bazingaTaskManager.schedule(new SleepTask(createPayload()));
    }

    public void addLoadTask() {
        bazingaTaskManager.schedule(new CpuLoadTask(createPayload()));
    }

    public void addMultiplicationTask() {
        bazingaTaskManager.schedule(new MultiplicationTask(createPayload()));
    }

    public void addTask(AbstractLoadTask task) {
        bazingaTaskManager.schedule(task);
    }

    public void addQuickMovePostprocessTask() {
        String area =
                Random2.R.nextEnum(ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceArea.class).value();
        bazingaTaskManager.schedule(new QuickMovePostProcessTask(
                new QuickMovePostProcessTask.QuickMovePostProcessParameters(
                        String.valueOf(Math.abs(Random2.R.nextLong())),
                        area,
                        "/" + area + "/" + Random2.R.nextLetters(20)
                )));
    }

    private DummyPayload createPayload() {
        return new DummyPayload(Random2.R.nextAlnum(payloadSizeKb.get()));
    }


}
