package ru.yandex.chemodan.app.bazingaload.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.bazingaload.TasksManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.dynproperties.DynamicProperty;

public abstract class AbstractLoadTask extends OnetimeTaskSupport<DummyPayload> {
    private DynamicProperty<Boolean> reschedule = new DynamicProperty<Boolean>("tasks--reschedule", false);
    protected TasksManager tasksManager;

    public AbstractLoadTask(DummyPayload parameters) {
        super(parameters);
    }

    public AbstractLoadTask(TasksManager tasksManager) {
        super(DummyPayload.class);
        this.tasksManager = tasksManager;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    protected abstract void doWork() throws Exception;

    @Override
    protected void execute(DummyPayload parameters, ExecutionContext context) throws Exception {
        try {
            doWork();
        } finally {
            if (reschedule.get()) {
                tasksManager.addTask(this);
            }
        }
    }
}
